{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitFormIntensitatDurada;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ToolWin, ComCtrls, MMSystem, ExtCtrls, StdCtrls;

const
  MaximPosicionsViatge = 2048;

type
  TFormIntensitatDurada = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonEngegarPararGlobus: TSpeedButton;
    CheckBoxLiniesAlMateixLLoc: TCheckBox;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    procedure FormPaint(Sender: TObject);
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
    procedure SpeedButtonEngegarPararGlobusClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    ComptadorPosicio:integer;
    PosicioPrimeraLinia, PosicioSegonaLinia:integer;
    Circuit:array[0..1,0..MaximPosicionsViatge] of integer;
  end;

var
  FormIntensitatDurada: TFormIntensitatDurada;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitEntradaSo, UnitDadesGlobus2, UnitCalculFFT, UnitTools;

{$R *.DFM}

procedure TFormIntensitatDurada.FormCreate(Sender: TObject);
var
  i,n:integer;
begin
  Top:=0;
  Left:=0;
  Width:=Screen.Width;
  ClientHeight:=Panel.Height+4*132;
  for i:=0 to MaximPosicionsViatge do for n:=0 to 1 do Circuit[n,i]:=0;
  PosicioPrimeraLinia:=Panel.Height+132;
  PosicioSegonaLinia:=Panel.Height+3*132;
end;

procedure TFormIntensitatDurada.FormPaint(Sender: TObject);
var
  i:integer;
begin
  Canvas.Pen.Color:=clBlue;
  Canvas.MoveTo(0,PosicioPrimeraLinia);
  Canvas.LineTo(ClientWidth,PosicioPrimeraLinia);
  for i:=0 to ClientWidth do begin
    Canvas.MoveTo(i,Circuit[0,i]+PosicioPrimeraLinia);
    Canvas.LineTo(i,-Circuit[0,i]+PosicioPrimeraLinia);
  end;
  Canvas.Pen.Color:=clBlack;
  Canvas.MoveTo(0,PosicioSegonaLinia);
  Canvas.LineTo(ClientWidth,PosicioSegonaLinia);
  if ClientWidth>MaximPosicionsViatge then ClientWidth:=MaximPosicionsViatge;
  for i:=0 to ClientWidth do begin
    Canvas.MoveTo(i,Circuit[1,i]+PosicioSegonaLinia);
    Canvas.LineTo(i,-Circuit[1,i]+PosicioSegonaLinia);
  end;
end;

procedure TFormIntensitatDurada.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormIntensitatDurada.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
  Energia:single;
  SumaFFT1000,SumaFFT2000,SumaFFT5000,SumaFFT:single;
  TpCSumaFFT1000,TpCSumaFFT2000,TpCSumaFFT5000:integer;
  s1,s2,s3,s:string;
begin

  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if SpeedButtonEngegarParar.Down then
   Circuit[0,ComptadorPosicio]:=Max
  else if SpeedButtonEngegarPararglobus.Down then
   Circuit[1,ComptadorPosicio]:=Max;
  {
  Canvas.MoveTo(ComptadorPosicio,PosicioPrimeraLinia-Max);
  Canvas.LineTo(ComptadorPosicio,PosicioPrimeraLinia+Max);
  }
  {
  For i:=1 to BytesBuffer do CoeficientsDenFourier[2,i]:=so[NumeroBufer,i]-127;
  CalculFFT(BytesBuffer);
  Energia:=0;
  For i:=1 to (BytesBuffer div 2) do Energia:=Energia+CoeficientsDenFourier[2,i]*CoeficientsDenFourier[2,i];
  //Max:=Round((Energia/(BytesBuffer div 2))) div 128;
  Max:=Round(Energia) //div 128;
  //Canvas.MoveTo(ComptadorPosicio,127-Max);
  //Canvas.LineTo(ComptadorPosicio,127+Max);
  }
  {
  SumaFFT1000:=0;
  SumaFFT2000:=0;
  SumaFFT5000:=0;
  for i:=1 to (BytesBuffer div 2) do begin
    if CoeficientsDenFourier[1,i]>0 then begin
      if (CoeficientsDenFourier[1,i]<=1000) then begin
        SumaFFT1000:=SumaFFT1000+CoeficientsDenFourier[2,i];
      end else if CoeficientsDenFourier[1,i]<=2000 then begin
        SumaFFT2000:=SumaFFT2000+CoeficientsDenFourier[2,i];
      end else begin
        SumaFFT5000:=SumaFFT5000+CoeficientsDenFourier[2,i];
      end;
    end;
  end;
  SumaFFT:=SumaFFT1000+SumaFFT2000+SumaFFT5000;
  if SumaFFT>0 then begin
    TpCSumaFFT1000:=round(SumaFFT1000/SumaFFT*100);
    TpCSumaFFT2000:=round(SumaFFT2000/SumaFFT*100);
    TpCSumaFFT5000:=round(SumaFFT5000/SumaFFT*100);
    s1:=IntToStr(TpCSumaFFT1000);
    if length(s1)=1 then s1:='0'+s1;
    s2:=IntToStr(TpCSumaFFT2000);
    if length(s2)=1 then s2:='0'+s2;
    s3:=IntToStr(TpCSumaFFT5000);
    if length(s3)=1 then s3:='0'+s3;
    s:=s1+', '+s2+', '+s3;
    //if TpCSumaFFT1000>TpCSumaFFT5000 then begin
    if TpCSumaFFT1000>50 then begin
      Canvas.Font.Color:=clBlue;
      s:=s+' | Sonor';
      Canvas.Pen.Color:=clBlue;
    end else begin
      Canvas.Font.Color:=clRed;
      s:=s+' | Sord';
      Canvas.Pen.Color:=clRed;
    end;
    Canvas.TextOut(1,32,s);
    //Max:=Round(SumaFFT);
    Canvas.MoveTo(ComptadorPosicio,127-Max);
    Canvas.LineTo(ComptadorPosicio,127+Max);
  end;
  }
  Repaint;
  inc(ComptadorPosicio);
  if ComptadorPosicio<ClientWidth then begin
    Canvas.Pen.Color:=clBlue;
    Canvas.MoveTo(ComptadorPosicio,Panel.Height);
    Canvas.LineTo(ComptadorPosicio,ClientHeight);
  end;
  if ComptadorPosicio>ClientWidth then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end else EntradaSo;
end;

procedure TFormIntensitatDurada.SpeedButtonEngegarPararClick(Sender: TObject);
var
  i,n:integer;
begin
  if SpeedButtonEngegarParar.Down then begin
    for i:=0 to MaximPosicionsViatge do for n:=0 to 1 do Circuit[n,i]:=0;
    SpeedButtonEngegarParar.Caption:='P';
    SpeedButtonEngegarPararGlobus.Enabled:=false;
    ComptadorPosicio:=0;
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormIntensitatDurada.SpeedButtonEngegarPararGlobusClick(Sender: TObject);
var
  i:integer;
begin
  if SpeedButtonEngegarPararGlobus.Down then begin
    for i:=0 to MaximPosicionsViatge do Circuit[1,i]:=0;
    SpeedButtonEngegarPararGlobus.Caption:='PG';
    SpeedButtonEngegarParar.Enabled:=false;
    ComptadorPosicio:=0;
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarParar.Enabled:=true;
  end;
end;

procedure TFormIntensitatDurada.CheckBoxLiniesAlMateixLLocClick(Sender: TObject);
begin
  if CheckBoxLiniesAlMateixLLoc.Checked then PosicioSegonaLinia:=Panel.Height+132 else PosicioSegonaLinia:=Panel.Height+3*132;
  Repaint;
end;


procedure TFormIntensitatDurada.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormIntensitatDurada.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
      SpeedButtonEngegarParar.Enabled:=true;
      SpeedButtonEngegarPararGlobus.Caption:='EG';
      SpeedButtonEngegarPararGlobus.Down:=false;
      SpeedButtonEngegarPararGlobus.Enabled:=true;
    end;
  end;
end;

end.
